package zio.aws.iam.model
import zio.aws.iam.model.primitives.RoleNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRolePermissionsBoundaryRequest(roleName: RoleNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest = {
    import DeleteRolePermissionsBoundaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest.ReadOnly =
    zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest.wrap(buildAwsValue())
}
object DeleteRolePermissionsBoundaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest =
      zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest(roleName)
    def roleName: RoleNameType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest
  ) extends zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest
  ): zio.aws.iam.model.DeleteRolePermissionsBoundaryRequest.ReadOnly =
    new Wrapper(impl)
}
