package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait DeletionTaskStatusType {
  def unwrap: software.amazon.awssdk.services.iam.model.DeletionTaskStatusType
}
object DeletionTaskStatusType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.DeletionTaskStatusType
  ): zio.aws.iam.model.DeletionTaskStatusType = value match {
    case software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.NOT_STARTED =>
      val r = NOT_STARTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iam.model.DeletionTaskStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.DeletionTaskStatusType =
      software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED extends zio.aws.iam.model.DeletionTaskStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.DeletionTaskStatusType =
      software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.SUCCEEDED
  }
  case object IN_PROGRESS extends zio.aws.iam.model.DeletionTaskStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.DeletionTaskStatusType =
      software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.IN_PROGRESS
  }
  case object FAILED extends zio.aws.iam.model.DeletionTaskStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.DeletionTaskStatusType =
      software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.FAILED
  }
  case object NOT_STARTED extends zio.aws.iam.model.DeletionTaskStatusType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.DeletionTaskStatusType =
      software.amazon.awssdk.services.iam.model.DeletionTaskStatusType.NOT_STARTED
  }
}
