package zio.aws.iam.model
import zio.aws.iam.model.primitives.JobIDType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GenerateServiceLastAccessedDetailsResponse(
    jobId: Optional[JobIDType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse = {
    import GenerateServiceLastAccessedDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobIDType.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly =
    zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse
      .wrap(buildAwsValue())
}
object GenerateServiceLastAccessedDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse =
      zio.aws.iam.model
        .GenerateServiceLastAccessedDetailsResponse(jobId.map(value => value))
    def jobId: Optional[JobIDType]
    def getJobId: ZIO[Any, AwsError, JobIDType] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse
  ) extends zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly {
    override val jobId: Optional[JobIDType] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.iam.model.primitives.JobIDType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse
  ): zio.aws.iam.model.GenerateServiceLastAccessedDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
