package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.SummaryValueType
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAccountSummaryResponse(
    summaryMap: Optional[
      Map[zio.aws.iam.model.SummaryKeyType, SummaryValueType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse = {
    import GetAccountSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse
      .builder()
      .optionallyWith(
        summaryMap.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (SummaryValueType.unwrap(value): Integer)
            })
            .asJava
        )
      )(_.summaryMapWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly =
    zio.aws.iam.model.GetAccountSummaryResponse.wrap(buildAwsValue())
}
object GetAccountSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetAccountSummaryResponse =
      zio.aws.iam.model
        .GetAccountSummaryResponse(summaryMap.map(value => value))
    def summaryMap
        : Optional[Map[zio.aws.iam.model.SummaryKeyType, SummaryValueType]]
    def getSummaryMap: ZIO[Any, AwsError, Map[
      zio.aws.iam.model.SummaryKeyType,
      SummaryValueType
    ]] = AwsError.unwrapOptionField("summaryMap", summaryMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse
  ) extends zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly {
    override val summaryMap
        : Optional[Map[zio.aws.iam.model.SummaryKeyType, SummaryValueType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iam.model.SummaryKeyType.wrap(
                key
              ) -> zio.aws.iam.model.primitives.SummaryValueType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse
  ): zio.aws.iam.model.GetAccountSummaryResponse.ReadOnly = new Wrapper(impl)
}
