package zio.aws.iam.model
import zio.aws.iam.model.primitives.PolicyDocumentType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetContextKeysForCustomPolicyRequest(
    policyInputList: Iterable[PolicyDocumentType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest = {
    import GetContextKeysForCustomPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest
      .builder()
      .policyInputList(policyInputList.map { item =>
        PolicyDocumentType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetContextKeysForCustomPolicyRequest.ReadOnly =
    zio.aws.iam.model.GetContextKeysForCustomPolicyRequest.wrap(buildAwsValue())
}
object GetContextKeysForCustomPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetContextKeysForCustomPolicyRequest =
      zio.aws.iam.model.GetContextKeysForCustomPolicyRequest(policyInputList)
    def policyInputList: List[PolicyDocumentType]
    def getPolicyInputList: ZIO[Any, Nothing, List[PolicyDocumentType]] =
      ZIO.succeed(policyInputList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest
  ) extends zio.aws.iam.model.GetContextKeysForCustomPolicyRequest.ReadOnly {
    override val policyInputList: List[PolicyDocumentType] = impl
      .policyInputList()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.PolicyDocumentType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest
  ): zio.aws.iam.model.GetContextKeysForCustomPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
