package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PolicyDocumentType,
  PolicyNameType,
  GroupNameType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetGroupPolicyResponse(
    groupName: GroupNameType,
    policyName: PolicyNameType,
    policyDocument: PolicyDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse = {
    import GetGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse
      .builder()
      .groupName(GroupNameType.unwrap(groupName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly =
    zio.aws.iam.model.GetGroupPolicyResponse.wrap(buildAwsValue())
}
object GetGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetGroupPolicyResponse = zio.aws.iam.model
      .GetGroupPolicyResponse(groupName, policyName, policyDocument)
    def groupName: GroupNameType
    def policyName: PolicyNameType
    def policyDocument: PolicyDocumentType
    def getGroupName: ZIO[Any, Nothing, GroupNameType] = ZIO.succeed(groupName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse
  ) extends zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly {
    override val groupName: GroupNameType =
      zio.aws.iam.model.primitives.GroupNameType(impl.groupName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse
  ): zio.aws.iam.model.GetGroupPolicyResponse.ReadOnly = new Wrapper(impl)
}
