package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest = {
    import GetOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.GetOpenIdConnectProviderRequest.wrap(buildAwsValue())
}
object GetOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOpenIdConnectProviderRequest =
      zio.aws.iam.model
        .GetOpenIdConnectProviderRequest(openIDConnectProviderArn)
    def openIDConnectProviderArn: ArnType
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.GetOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest
  ): zio.aws.iam.model.GetOpenIdConnectProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
