package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  DateType,
  ThumbprintType,
  ClientIDType,
  OpenIDConnectProviderUrlType
}
import scala.jdk.CollectionConverters.*
final case class GetOpenIdConnectProviderResponse(
    url: Optional[OpenIDConnectProviderUrlType] = Optional.Absent,
    clientIDList: Optional[Iterable[ClientIDType]] = Optional.Absent,
    thumbprintList: Optional[Iterable[ThumbprintType]] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse = {
    import GetOpenIdConnectProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse
      .builder()
      .optionallyWith(
        url.map(value =>
          OpenIDConnectProviderUrlType.unwrap(value): java.lang.String
        )
      )(_.url)
      .optionallyWith(
        clientIDList.map(value =>
          value.map { item =>
            ClientIDType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.clientIDList)
      .optionallyWith(
        thumbprintList.map(value =>
          value.map { item =>
            ThumbprintType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.thumbprintList)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly =
    zio.aws.iam.model.GetOpenIdConnectProviderResponse.wrap(buildAwsValue())
}
object GetOpenIdConnectProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetOpenIdConnectProviderResponse =
      zio.aws.iam.model.GetOpenIdConnectProviderResponse(
        url.map(value => value),
        clientIDList.map(value => value),
        thumbprintList.map(value => value),
        createDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def url: Optional[OpenIDConnectProviderUrlType]
    def clientIDList: Optional[List[ClientIDType]]
    def thumbprintList: Optional[List[ThumbprintType]]
    def createDate: Optional[DateType]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getUrl: ZIO[Any, AwsError, OpenIDConnectProviderUrlType] =
      AwsError.unwrapOptionField("url", url)
    def getClientIDList: ZIO[Any, AwsError, List[ClientIDType]] =
      AwsError.unwrapOptionField("clientIDList", clientIDList)
    def getThumbprintList: ZIO[Any, AwsError, List[ThumbprintType]] =
      AwsError.unwrapOptionField("thumbprintList", thumbprintList)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse
  ) extends zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly {
    override val url: Optional[OpenIDConnectProviderUrlType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.url())
        .map(value =>
          zio.aws.iam.model.primitives.OpenIDConnectProviderUrlType(value)
        )
    override val clientIDList: Optional[List[ClientIDType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientIDList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ClientIDType(item)
          }.toList
        )
    override val thumbprintList: Optional[List[ThumbprintType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbprintList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ThumbprintType(item)
          }.toList
        )
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse
  ): zio.aws.iam.model.GetOpenIdConnectProviderResponse.ReadOnly = new Wrapper(
    impl
  )
}
