package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPolicyRequest(policyArn: ArnType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetPolicyRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetPolicyRequest.ReadOnly =
    zio.aws.iam.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetPolicyRequest =
      zio.aws.iam.model.GetPolicyRequest(policyArn)
    def policyArn: ArnType
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyRequest
  ) extends zio.aws.iam.model.GetPolicyRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetPolicyRequest
  ): zio.aws.iam.model.GetPolicyRequest.ReadOnly = new Wrapper(impl)
}
