package zio.aws.iam.model
import zio.aws.iam.model.primitives.RoleNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRoleRequest(roleName: RoleNameType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetRoleRequest = {
    import GetRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetRoleRequest.ReadOnly =
    zio.aws.iam.model.GetRoleRequest.wrap(buildAwsValue())
}
object GetRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetRoleRequest =
      zio.aws.iam.model.GetRoleRequest(roleName)
    def roleName: RoleNameType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetRoleRequest
  ) extends zio.aws.iam.model.GetRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetRoleRequest
  ): zio.aws.iam.model.GetRoleRequest.ReadOnly = new Wrapper(impl)
}
