package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRoleResponse(role: zio.aws.iam.model.Role) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetRoleResponse = {
    import GetRoleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetRoleResponse
      .builder()
      .role(role.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetRoleResponse.ReadOnly =
    zio.aws.iam.model.GetRoleResponse.wrap(buildAwsValue())
}
object GetRoleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetRoleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetRoleResponse =
      zio.aws.iam.model.GetRoleResponse(role.asEditable)
    def role: zio.aws.iam.model.Role.ReadOnly
    def getRole: ZIO[Any, Nothing, zio.aws.iam.model.Role.ReadOnly] =
      ZIO.succeed(role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetRoleResponse
  ) extends zio.aws.iam.model.GetRoleResponse.ReadOnly {
    override val role: zio.aws.iam.model.Role.ReadOnly =
      zio.aws.iam.model.Role.wrap(impl.role())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetRoleResponse
  ): zio.aws.iam.model.GetRoleResponse.ReadOnly = new Wrapper(impl)
}
