package zio.aws.iam.model
import zio.aws.iam.model.primitives.ServerCertificateNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServerCertificateRequest(
    serverCertificateName: ServerCertificateNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServerCertificateRequest = {
    import GetServerCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServerCertificateRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetServerCertificateRequest.ReadOnly =
    zio.aws.iam.model.GetServerCertificateRequest.wrap(buildAwsValue())
}
object GetServerCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServerCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetServerCertificateRequest =
      zio.aws.iam.model.GetServerCertificateRequest(serverCertificateName)
    def serverCertificateName: ServerCertificateNameType
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServerCertificateRequest
  ) extends zio.aws.iam.model.GetServerCertificateRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServerCertificateRequest
  ): zio.aws.iam.model.GetServerCertificateRequest.ReadOnly = new Wrapper(impl)
}
