package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServerCertificateResponse(
    serverCertificate: zio.aws.iam.model.ServerCertificate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServerCertificateResponse = {
    import GetServerCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServerCertificateResponse
      .builder()
      .serverCertificate(serverCertificate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetServerCertificateResponse.ReadOnly =
    zio.aws.iam.model.GetServerCertificateResponse.wrap(buildAwsValue())
}
object GetServerCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServerCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetServerCertificateResponse =
      zio.aws.iam.model
        .GetServerCertificateResponse(serverCertificate.asEditable)
    def serverCertificate: zio.aws.iam.model.ServerCertificate.ReadOnly
    def getServerCertificate
        : ZIO[Any, Nothing, zio.aws.iam.model.ServerCertificate.ReadOnly] =
      ZIO.succeed(serverCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServerCertificateResponse
  ) extends zio.aws.iam.model.GetServerCertificateResponse.ReadOnly {
    override val serverCertificate
        : zio.aws.iam.model.ServerCertificate.ReadOnly =
      zio.aws.iam.model.ServerCertificate.wrap(impl.serverCertificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServerCertificateResponse
  ): zio.aws.iam.model.GetServerCertificateResponse.ReadOnly = new Wrapper(impl)
}
