package zio.aws.iam.model
import zio.aws.iam.model.primitives.DeletionTaskIdType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServiceLinkedRoleDeletionStatusRequest(
    deletionTaskId: DeletionTaskIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest = {
    import GetServiceLinkedRoleDeletionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest
      .builder()
      .deletionTaskId(
        DeletionTaskIdType.unwrap(deletionTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest.ReadOnly =
    zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest
      .wrap(buildAwsValue())
}
object GetServiceLinkedRoleDeletionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest =
      zio.aws.iam.model
        .GetServiceLinkedRoleDeletionStatusRequest(deletionTaskId)
    def deletionTaskId: DeletionTaskIdType
    def getDeletionTaskId: ZIO[Any, Nothing, DeletionTaskIdType] =
      ZIO.succeed(deletionTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest
  ) extends zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest.ReadOnly {
    override val deletionTaskId: DeletionTaskIdType =
      zio.aws.iam.model.primitives.DeletionTaskIdType(impl.deletionTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest
  ): zio.aws.iam.model.GetServiceLinkedRoleDeletionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
