package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PublicKeyIdType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSshPublicKeyRequest(
    userName: UserNameType,
    sshPublicKeyId: PublicKeyIdType,
    encoding: zio.aws.iam.model.EncodingType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest = {
    import GetSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .sshPublicKeyId(PublicKeyIdType.unwrap(sshPublicKeyId): java.lang.String)
      .encoding(encoding.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetSshPublicKeyRequest.ReadOnly =
    zio.aws.iam.model.GetSshPublicKeyRequest.wrap(buildAwsValue())
}
object GetSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetSshPublicKeyRequest = zio.aws.iam.model
      .GetSshPublicKeyRequest(userName, sshPublicKeyId, encoding)
    def userName: UserNameType
    def sshPublicKeyId: PublicKeyIdType
    def encoding: zio.aws.iam.model.EncodingType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSshPublicKeyId: ZIO[Any, Nothing, PublicKeyIdType] =
      ZIO.succeed(sshPublicKeyId)
    def getEncoding: ZIO[Any, Nothing, zio.aws.iam.model.EncodingType] =
      ZIO.succeed(encoding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest
  ) extends zio.aws.iam.model.GetSshPublicKeyRequest.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val sshPublicKeyId: PublicKeyIdType =
      zio.aws.iam.model.primitives.PublicKeyIdType(impl.sshPublicKeyId())
    override val encoding: zio.aws.iam.model.EncodingType =
      zio.aws.iam.model.EncodingType.wrap(impl.encoding())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest
  ): zio.aws.iam.model.GetSshPublicKeyRequest.ReadOnly = new Wrapper(impl)
}
