package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetUserResponse(user: zio.aws.iam.model.User) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.GetUserResponse = {
    import GetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.GetUserResponse
      .builder()
      .user(user.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iam.model.GetUserResponse.ReadOnly =
    zio.aws.iam.model.GetUserResponse.wrap(buildAwsValue())
}
object GetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.GetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.GetUserResponse =
      zio.aws.iam.model.GetUserResponse(user.asEditable)
    def user: zio.aws.iam.model.User.ReadOnly
    def getUser: ZIO[Any, Nothing, zio.aws.iam.model.User.ReadOnly] =
      ZIO.succeed(user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.GetUserResponse
  ) extends zio.aws.iam.model.GetUserResponse.ReadOnly {
    override val user: zio.aws.iam.model.User.ReadOnly =
      zio.aws.iam.model.User.wrap(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.GetUserResponse
  ): zio.aws.iam.model.GetUserResponse.ReadOnly = new Wrapper(impl)
}
