package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  InstanceProfileNameType,
  IdType,
  DateType,
  PathType
}
import scala.jdk.CollectionConverters.*
final case class InstanceProfile(
    path: PathType,
    instanceProfileName: InstanceProfileNameType,
    instanceProfileId: IdType,
    arn: ArnType,
    createDate: DateType,
    roles: Iterable[zio.aws.iam.model.Role],
    tags: Optional[Iterable[zio.aws.iam.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.InstanceProfile = {
    import InstanceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.InstanceProfile
      .builder()
      .path(PathType.unwrap(path): java.lang.String)
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .instanceProfileId(IdType.unwrap(instanceProfileId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .createDate(DateType.unwrap(createDate): Instant)
      .roles(roles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.InstanceProfile.ReadOnly =
    zio.aws.iam.model.InstanceProfile.wrap(buildAwsValue())
}
object InstanceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.InstanceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.InstanceProfile =
      zio.aws.iam.model.InstanceProfile(
        path,
        instanceProfileName,
        instanceProfileId,
        arn,
        createDate,
        roles.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: PathType
    def instanceProfileName: InstanceProfileNameType
    def instanceProfileId: IdType
    def arn: ArnType
    def createDate: DateType
    def roles: List[zio.aws.iam.model.Role.ReadOnly]
    def tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]]
    def getPath: ZIO[Any, Nothing, PathType] = ZIO.succeed(path)
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getInstanceProfileId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(instanceProfileId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getCreateDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(createDate)
    def getRoles: ZIO[Any, Nothing, List[zio.aws.iam.model.Role.ReadOnly]] =
      ZIO.succeed(roles)
    def getTags: ZIO[Any, AwsError, List[zio.aws.iam.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.InstanceProfile
  ) extends zio.aws.iam.model.InstanceProfile.ReadOnly {
    override val path: PathType =
      zio.aws.iam.model.primitives.PathType(impl.path())
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val instanceProfileId: IdType =
      zio.aws.iam.model.primitives.IdType(impl.instanceProfileId())
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val createDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.createDate())
    override val roles: List[zio.aws.iam.model.Role.ReadOnly] = impl
      .roles()
      .asScala
      .map { item =>
        zio.aws.iam.model.Role.wrap(item)
      }
      .toList
    override val tags: Optional[List[zio.aws.iam.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.InstanceProfile
  ): zio.aws.iam.model.InstanceProfile.ReadOnly = new Wrapper(impl)
}
