package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ExistingUserNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccessKeysRequest(
    userName: Optional[ExistingUserNameType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAccessKeysRequest = {
    import ListAccessKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
      .builder()
      .optionallyWith(
        userName.map(value =>
          ExistingUserNameType.unwrap(value): java.lang.String
        )
      )(_.userName)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAccessKeysRequest.ReadOnly =
    zio.aws.iam.model.ListAccessKeysRequest.wrap(buildAwsValue())
}
object ListAccessKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAccessKeysRequest =
      zio.aws.iam.model.ListAccessKeysRequest(
        userName.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def userName: Optional[ExistingUserNameType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getUserName: ZIO[Any, AwsError, ExistingUserNameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ) extends zio.aws.iam.model.ListAccessKeysRequest.ReadOnly {
    override val userName: Optional[ExistingUserNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userName())
        .map(value => zio.aws.iam.model.primitives.ExistingUserNameType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAccessKeysRequest
  ): zio.aws.iam.model.ListAccessKeysRequest.ReadOnly = new Wrapper(impl)
}
