package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  ResponseMarkerType,
  BooleanType,
  AccountAliasType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccountAliasesResponse(
    accountAliases: Iterable[AccountAliasType],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse = {
    import ListAccountAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse
      .builder()
      .accountAliases(accountAliases.map { item =>
        AccountAliasType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly =
    zio.aws.iam.model.ListAccountAliasesResponse.wrap(buildAwsValue())
}
object ListAccountAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListAccountAliasesResponse =
      zio.aws.iam.model.ListAccountAliasesResponse(
        accountAliases,
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def accountAliases: List[AccountAliasType]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getAccountAliases: ZIO[Any, Nothing, List[AccountAliasType]] =
      ZIO.succeed(accountAliases)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse
  ) extends zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly {
    override val accountAliases: List[AccountAliasType] = impl
      .accountAliases()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.AccountAliasType(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse
  ): zio.aws.iam.model.ListAccountAliasesResponse.ReadOnly = new Wrapper(impl)
}
