package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, PathPrefixType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListInstanceProfilesRequest(
    pathPrefix: Optional[PathPrefixType] = Optional.Absent,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest = {
    import ListInstanceProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest
      .builder()
      .optionallyWith(
        pathPrefix.map(value => PathPrefixType.unwrap(value): java.lang.String)
      )(_.pathPrefix)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListInstanceProfilesRequest.ReadOnly =
    zio.aws.iam.model.ListInstanceProfilesRequest.wrap(buildAwsValue())
}
object ListInstanceProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListInstanceProfilesRequest =
      zio.aws.iam.model.ListInstanceProfilesRequest(
        pathPrefix.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def pathPrefix: Optional[PathPrefixType]
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getPathPrefix: ZIO[Any, AwsError, PathPrefixType] =
      AwsError.unwrapOptionField("pathPrefix", pathPrefix)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest
  ) extends zio.aws.iam.model.ListInstanceProfilesRequest.ReadOnly {
    override val pathPrefix: Optional[PathPrefixType] = zio.aws.core.internal
      .optionalFromNullable(impl.pathPrefix())
      .map(value => zio.aws.iam.model.primitives.PathPrefixType(value))
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest
  ): zio.aws.iam.model.ListInstanceProfilesRequest.ReadOnly = new Wrapper(impl)
}
