package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOpenIdConnectProvidersResponse(
    openIDConnectProviderList: Optional[
      Iterable[zio.aws.iam.model.OpenIDConnectProviderListEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse = {
    import ListOpenIdConnectProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse
      .builder()
      .optionallyWith(
        openIDConnectProviderList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.openIDConnectProviderList)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly =
    zio.aws.iam.model.ListOpenIdConnectProvidersResponse.wrap(buildAwsValue())
}
object ListOpenIdConnectProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListOpenIdConnectProvidersResponse =
      zio.aws.iam.model.ListOpenIdConnectProvidersResponse(
        openIDConnectProviderList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def openIDConnectProviderList: Optional[
      List[zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly]
    ]
    def getOpenIDConnectProviderList: ZIO[Any, AwsError, List[
      zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "openIDConnectProviderList",
      openIDConnectProviderList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse
  ) extends zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly {
    override val openIDConnectProviderList: Optional[
      List[zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openIDConnectProviderList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.OpenIDConnectProviderListEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse
  ): zio.aws.iam.model.ListOpenIdConnectProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
