package zio.aws.iam.model
import zio.aws.iam.model.primitives.ServiceNamespaceType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPoliciesGrantingServiceAccessEntry(
    serviceNamespace: Optional[ServiceNamespaceType] = Optional.Absent,
    policies: Optional[
      Iterable[zio.aws.iam.model.PolicyGrantingServiceAccess]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry = {
    import ListPoliciesGrantingServiceAccessEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry
      .builder()
      .optionallyWith(
        serviceNamespace.map(value =>
          ServiceNamespaceType.unwrap(value): java.lang.String
        )
      )(_.serviceNamespace)
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly =
    zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry
      .wrap(buildAwsValue())
}
object ListPoliciesGrantingServiceAccessEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry =
      zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry(
        serviceNamespace.map(value => value),
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceNamespace: Optional[ServiceNamespaceType]
    def policies
        : Optional[List[zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly]]
    def getServiceNamespace: ZIO[Any, AwsError, ServiceNamespaceType] =
      AwsError.unwrapOptionField("serviceNamespace", serviceNamespace)
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry
  ) extends zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly {
    override val serviceNamespace: Optional[ServiceNamespaceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNamespace())
        .map(value => zio.aws.iam.model.primitives.ServiceNamespaceType(value))
    override val policies: Optional[
      List[zio.aws.iam.model.PolicyGrantingServiceAccess.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.PolicyGrantingServiceAccess.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessEntry
  ): zio.aws.iam.model.ListPoliciesGrantingServiceAccessEntry.ReadOnly =
    new Wrapper(impl)
}
