package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{MaxItemsType, MarkerType, RoleNameType}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRoleTagsRequest(
    roleName: RoleNameType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListRoleTagsRequest = {
    import ListRoleTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListRoleTagsRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListRoleTagsRequest.ReadOnly =
    zio.aws.iam.model.ListRoleTagsRequest.wrap(buildAwsValue())
}
object ListRoleTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListRoleTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListRoleTagsRequest =
      zio.aws.iam.model.ListRoleTagsRequest(
        roleName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def roleName: RoleNameType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListRoleTagsRequest
  ) extends zio.aws.iam.model.ListRoleTagsRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListRoleTagsRequest
  ): zio.aws.iam.model.ListRoleTagsRequest.ReadOnly = new Wrapper(impl)
}
