package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  MaxItemsType,
  MarkerType,
  ServerCertificateNameType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListServerCertificateTagsRequest(
    serverCertificateName: ServerCertificateNameType,
    marker: Optional[MarkerType] = Optional.Absent,
    maxItems: Optional[MaxItemsType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest = {
    import ListServerCertificateTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest
      .builder()
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxItemsType.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListServerCertificateTagsRequest.ReadOnly =
    zio.aws.iam.model.ListServerCertificateTagsRequest.wrap(buildAwsValue())
}
object ListServerCertificateTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListServerCertificateTagsRequest =
      zio.aws.iam.model.ListServerCertificateTagsRequest(
        serverCertificateName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def serverCertificateName: ServerCertificateNameType
    def marker: Optional[MarkerType]
    def maxItems: Optional[MaxItemsType]
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxItemsType] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest
  ) extends zio.aws.iam.model.ListServerCertificateTagsRequest.ReadOnly {
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val marker: Optional[MarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.MarkerType(value))
    override val maxItems: Optional[MaxItemsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.iam.model.primitives.MaxItemsType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest
  ): zio.aws.iam.model.ListServerCertificateTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
