package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSigningCertificatesResponse(
    certificates: Iterable[zio.aws.iam.model.SigningCertificate],
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse = {
    import ListSigningCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse
      .builder()
      .certificates(certificates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly =
    zio.aws.iam.model.ListSigningCertificatesResponse.wrap(buildAwsValue())
}
object ListSigningCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListSigningCertificatesResponse =
      zio.aws.iam.model.ListSigningCertificatesResponse(
        certificates.map { item =>
          item.asEditable
        },
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def certificates: List[zio.aws.iam.model.SigningCertificate.ReadOnly]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getCertificates: ZIO[Any, Nothing, List[
      zio.aws.iam.model.SigningCertificate.ReadOnly
    ]] = ZIO.succeed(certificates)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse
  ) extends zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly {
    override val certificates
        : List[zio.aws.iam.model.SigningCertificate.ReadOnly] = impl
      .certificates()
      .asScala
      .map { item =>
        zio.aws.iam.model.SigningCertificate.wrap(item)
      }
      .toList
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse
  ): zio.aws.iam.model.ListSigningCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
