package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ResponseMarkerType, BooleanType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSshPublicKeysResponse(
    sshPublicKeys: Optional[Iterable[zio.aws.iam.model.SSHPublicKeyMetadata]] =
      Optional.Absent,
    isTruncated: Optional[BooleanType] = Optional.Absent,
    marker: Optional[ResponseMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse = {
    import ListSshPublicKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse
      .builder()
      .optionallyWith(
        sshPublicKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sshPublicKeys)
      .optionallyWith(
        isTruncated.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => ResponseMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly =
    zio.aws.iam.model.ListSshPublicKeysResponse.wrap(buildAwsValue())
}
object ListSshPublicKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ListSshPublicKeysResponse =
      zio.aws.iam.model.ListSshPublicKeysResponse(
        sshPublicKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isTruncated.map(value => value),
        marker.map(value => value)
      )
    def sshPublicKeys
        : Optional[List[zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly]]
    def isTruncated: Optional[BooleanType]
    def marker: Optional[ResponseMarkerType]
    def getSshPublicKeys: ZIO[Any, AwsError, List[
      zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("sshPublicKeys", sshPublicKeys)
    def getIsTruncated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, ResponseMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse
  ) extends zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly {
    override val sshPublicKeys
        : Optional[List[zio.aws.iam.model.SSHPublicKeyMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshPublicKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.SSHPublicKeyMetadata.wrap(item)
          }.toList
        )
    override val isTruncated: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val marker: Optional[ResponseMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.iam.model.primitives.ResponseMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse
  ): zio.aws.iam.model.ListSshPublicKeysResponse.ReadOnly = new Wrapper(impl)
}
