package zio.aws.iam.model
import zio.aws.iam.model.primitives.{DateType, SerialNumberType, UserNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MFADevice(
    userName: UserNameType,
    serialNumber: SerialNumberType,
    enableDate: DateType
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.MFADevice = {
    import MFADevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.MFADevice
      .builder()
      .userName(UserNameType.unwrap(userName): java.lang.String)
      .serialNumber(SerialNumberType.unwrap(serialNumber): java.lang.String)
      .enableDate(DateType.unwrap(enableDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.MFADevice.ReadOnly =
    zio.aws.iam.model.MFADevice.wrap(buildAwsValue())
}
object MFADevice {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.MFADevice] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.MFADevice =
      zio.aws.iam.model.MFADevice(userName, serialNumber, enableDate)
    def userName: UserNameType
    def serialNumber: SerialNumberType
    def enableDate: DateType
    def getUserName: ZIO[Any, Nothing, UserNameType] = ZIO.succeed(userName)
    def getSerialNumber: ZIO[Any, Nothing, SerialNumberType] =
      ZIO.succeed(serialNumber)
    def getEnableDate: ZIO[Any, Nothing, DateType] = ZIO.succeed(enableDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.MFADevice
  ) extends zio.aws.iam.model.MFADevice.ReadOnly {
    override val userName: UserNameType =
      zio.aws.iam.model.primitives.UserNameType(impl.userName())
    override val serialNumber: SerialNumberType =
      zio.aws.iam.model.primitives.SerialNumberType(impl.serialNumber())
    override val enableDate: DateType =
      zio.aws.iam.model.primitives.DateType(impl.enableDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.MFADevice
  ): zio.aws.iam.model.MFADevice.ReadOnly = new Wrapper(impl)
}
