package zio.aws.iam.model
import zio.aws.iam.model.primitives.ArnType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenIDConnectProviderListEntry(
    arn: Optional[ArnType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry = {
    import OpenIDConnectProviderListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry
      .builder()
      .optionallyWith(
        arn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly =
    zio.aws.iam.model.OpenIDConnectProviderListEntry.wrap(buildAwsValue())
}
object OpenIDConnectProviderListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.OpenIDConnectProviderListEntry =
      zio.aws.iam.model.OpenIDConnectProviderListEntry(arn.map(value => value))
    def arn: Optional[ArnType]
    def getArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry
  ) extends zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly {
    override val arn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.OpenIDConnectProviderListEntry
  ): zio.aws.iam.model.OpenIDConnectProviderListEntry.ReadOnly = new Wrapper(
    impl
  )
}
