package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyDocumentType, PolicyNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyDetail(
    policyName: Optional[PolicyNameType] = Optional.Absent,
    policyDocument: Optional[PolicyDocumentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PolicyDetail = {
    import PolicyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyDetail
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyNameType.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyDocument.map(value =>
          PolicyDocumentType.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyDetail.ReadOnly =
    zio.aws.iam.model.PolicyDetail.wrap(buildAwsValue())
}
object PolicyDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.PolicyDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyDetail =
      zio.aws.iam.model.PolicyDetail(
        policyName.map(value => value),
        policyDocument.map(value => value)
      )
    def policyName: Optional[PolicyNameType]
    def policyDocument: Optional[PolicyDocumentType]
    def getPolicyName: ZIO[Any, AwsError, PolicyNameType] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyDocument: ZIO[Any, AwsError, PolicyDocumentType] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyDetail
  ) extends zio.aws.iam.model.PolicyDetail.ReadOnly {
    override val policyName: Optional[PolicyNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value => zio.aws.iam.model.primitives.PolicyNameType(value))
    override val policyDocument: Optional[PolicyDocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value => zio.aws.iam.model.primitives.PolicyDocumentType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyDetail
  ): zio.aws.iam.model.PolicyDetail.ReadOnly = new Wrapper(impl)
}
