package zio.aws.iam.model
import zio.aws.iam.model.primitives.{IdType, GroupNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyGroup(
    groupName: Optional[GroupNameType] = Optional.Absent,
    groupId: Optional[IdType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.PolicyGroup = {
    import PolicyGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PolicyGroup
      .builder()
      .optionallyWith(
        groupName.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PolicyGroup.ReadOnly =
    zio.aws.iam.model.PolicyGroup.wrap(buildAwsValue())
}
object PolicyGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.PolicyGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PolicyGroup = zio.aws.iam.model
      .PolicyGroup(groupName.map(value => value), groupId.map(value => value))
    def groupName: Optional[GroupNameType]
    def groupId: Optional[IdType]
    def getGroupName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PolicyGroup
  ) extends zio.aws.iam.model.PolicyGroup.ReadOnly {
    override val groupName: Optional[GroupNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.iam.model.primitives.GroupNameType(value))
    override val groupId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.iam.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PolicyGroup
  ): zio.aws.iam.model.PolicyGroup.ReadOnly = new Wrapper(impl)
}
