package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait PolicySourceType {
  def unwrap: software.amazon.awssdk.services.iam.model.PolicySourceType
}
object PolicySourceType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.PolicySourceType
  ): zio.aws.iam.model.PolicySourceType = value match {
    case software.amazon.awssdk.services.iam.model.PolicySourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.USER =>
      val r = user
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.GROUP =>
      val r = group
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.ROLE =>
      val r = role
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.AWS_MANAGED =>
      val r = `aws-managed`
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.USER_MANAGED =>
      val r = `user-managed`
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.RESOURCE =>
      val r = resource
      r
    case software.amazon.awssdk.services.iam.model.PolicySourceType.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object user extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.USER
  }
  case object group extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.GROUP
  }
  case object role extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.ROLE
  }
  case object `aws-managed` extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.AWS_MANAGED
  }
  case object `user-managed` extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.USER_MANAGED
  }
  case object resource extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.RESOURCE
  }
  case object none extends zio.aws.iam.model.PolicySourceType {
    override def unwrap
        : software.amazon.awssdk.services.iam.model.PolicySourceType =
      software.amazon.awssdk.services.iam.model.PolicySourceType.NONE
  }
}
