package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{ColumnNumber, LineNumber}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Position(
    line: Optional[LineNumber] = Optional.Absent,
    column: Optional[ColumnNumber] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iam.model.Position = {
    import Position.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.Position
      .builder()
      .optionallyWith(line.map(value => LineNumber.unwrap(value): Integer))(
        _.line
      )
      .optionallyWith(column.map(value => ColumnNumber.unwrap(value): Integer))(
        _.column
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.Position.ReadOnly =
    zio.aws.iam.model.Position.wrap(buildAwsValue())
}
object Position {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.Position] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.Position = zio.aws.iam.model
      .Position(line.map(value => value), column.map(value => value))
    def line: Optional[LineNumber]
    def column: Optional[ColumnNumber]
    def getLine: ZIO[Any, AwsError, LineNumber] =
      AwsError.unwrapOptionField("line", line)
    def getColumn: ZIO[Any, AwsError, ColumnNumber] =
      AwsError.unwrapOptionField("column", column)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.Position
  ) extends zio.aws.iam.model.Position.ReadOnly {
    override val line: Optional[LineNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.line())
      .map(value => zio.aws.iam.model.primitives.LineNumber(value))
    override val column: Optional[ColumnNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.column())
      .map(value => zio.aws.iam.model.primitives.ColumnNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.Position
  ): zio.aws.iam.model.Position.ReadOnly = new Wrapper(impl)
}
