package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutRolePermissionsBoundaryRequest(
    roleName: RoleNameType,
    permissionsBoundary: ArnType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest = {
    import PutRolePermissionsBoundaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .permissionsBoundary(
        ArnType.unwrap(permissionsBoundary): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PutRolePermissionsBoundaryRequest.ReadOnly =
    zio.aws.iam.model.PutRolePermissionsBoundaryRequest.wrap(buildAwsValue())
}
object PutRolePermissionsBoundaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PutRolePermissionsBoundaryRequest =
      zio.aws.iam.model
        .PutRolePermissionsBoundaryRequest(roleName, permissionsBoundary)
    def roleName: RoleNameType
    def permissionsBoundary: ArnType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPermissionsBoundary: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(permissionsBoundary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest
  ) extends zio.aws.iam.model.PutRolePermissionsBoundaryRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val permissionsBoundary: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.permissionsBoundary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest
  ): zio.aws.iam.model.PutRolePermissionsBoundaryRequest.ReadOnly = new Wrapper(
    impl
  )
}
