package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PolicyDocumentType,
  PolicyNameType,
  RoleNameType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutRolePolicyRequest(
    roleName: RoleNameType,
    policyName: PolicyNameType,
    policyDocument: PolicyDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PutRolePolicyRequest = {
    import PutRolePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PutRolePolicyRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PutRolePolicyRequest.ReadOnly =
    zio.aws.iam.model.PutRolePolicyRequest.wrap(buildAwsValue())
}
object PutRolePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PutRolePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PutRolePolicyRequest = zio.aws.iam.model
      .PutRolePolicyRequest(roleName, policyName, policyDocument)
    def roleName: RoleNameType
    def policyName: PolicyNameType
    def policyDocument: PolicyDocumentType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PutRolePolicyRequest
  ) extends zio.aws.iam.model.PutRolePolicyRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PutRolePolicyRequest
  ): zio.aws.iam.model.PutRolePolicyRequest.ReadOnly = new Wrapper(impl)
}
