package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  PolicyDocumentType,
  PolicyNameType,
  ExistingUserNameType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutUserPolicyRequest(
    userName: ExistingUserNameType,
    policyName: PolicyNameType,
    policyDocument: PolicyDocumentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.PutUserPolicyRequest = {
    import PutUserPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.PutUserPolicyRequest
      .builder()
      .userName(ExistingUserNameType.unwrap(userName): java.lang.String)
      .policyName(PolicyNameType.unwrap(policyName): java.lang.String)
      .policyDocument(
        PolicyDocumentType.unwrap(policyDocument): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.PutUserPolicyRequest.ReadOnly =
    zio.aws.iam.model.PutUserPolicyRequest.wrap(buildAwsValue())
}
object PutUserPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.PutUserPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.PutUserPolicyRequest = zio.aws.iam.model
      .PutUserPolicyRequest(userName, policyName, policyDocument)
    def userName: ExistingUserNameType
    def policyName: PolicyNameType
    def policyDocument: PolicyDocumentType
    def getUserName: ZIO[Any, Nothing, ExistingUserNameType] =
      ZIO.succeed(userName)
    def getPolicyName: ZIO[Any, Nothing, PolicyNameType] =
      ZIO.succeed(policyName)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocumentType] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.PutUserPolicyRequest
  ) extends zio.aws.iam.model.PutUserPolicyRequest.ReadOnly {
    override val userName: ExistingUserNameType =
      zio.aws.iam.model.primitives.ExistingUserNameType(impl.userName())
    override val policyName: PolicyNameType =
      zio.aws.iam.model.primitives.PolicyNameType(impl.policyName())
    override val policyDocument: PolicyDocumentType =
      zio.aws.iam.model.primitives.PolicyDocumentType(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.PutUserPolicyRequest
  ): zio.aws.iam.model.PutUserPolicyRequest.ReadOnly = new Wrapper(impl)
}
