package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ClientIDType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveClientIdFromOpenIdConnectProviderRequest(
    openIDConnectProviderArn: ArnType,
    clientID: ClientIDType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest = {
    import RemoveClientIdFromOpenIdConnectProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
      .builder()
      .openIDConnectProviderArn(
        ArnType.unwrap(openIDConnectProviderArn): java.lang.String
      )
      .clientID(ClientIDType.unwrap(clientID): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest.ReadOnly =
    zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
      .wrap(buildAwsValue())
}
object RemoveClientIdFromOpenIdConnectProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest =
      zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest(
        openIDConnectProviderArn,
        clientID
      )
    def openIDConnectProviderArn: ArnType
    def clientID: ClientIDType
    def getOpenIDConnectProviderArn: ZIO[Any, Nothing, ArnType] =
      ZIO.succeed(openIDConnectProviderArn)
    def getClientID: ZIO[Any, Nothing, ClientIDType] = ZIO.succeed(clientID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
  ) extends zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest.ReadOnly {
    override val openIDConnectProviderArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.openIDConnectProviderArn())
    override val clientID: ClientIDType =
      zio.aws.iam.model.primitives.ClientIDType(impl.clientID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest
  ): zio.aws.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest.ReadOnly =
    new Wrapper(impl)
}
