package zio.aws.iam.model
import zio.aws.iam.model.primitives.{RoleNameType, InstanceProfileNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveRoleFromInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType,
    roleName: RoleNameType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest = {
    import RemoveRoleFromInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest.wrap(buildAwsValue())
}
object RemoveRoleFromInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest =
      zio.aws.iam.model
        .RemoveRoleFromInstanceProfileRequest(instanceProfileName, roleName)
    def instanceProfileName: InstanceProfileNameType
    def roleName: RoleNameType
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest
  ) extends zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest
  ): zio.aws.iam.model.RemoveRoleFromInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
