package zio.aws.iam.model
import zio.aws.iam.model.primitives.{
  EvalDecisionSourceType,
  ContextKeyNameType,
  ResourceNameType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceSpecificResult(
    evalResourceName: ResourceNameType,
    evalResourceDecision: zio.aws.iam.model.PolicyEvaluationDecisionType,
    matchedStatements: Optional[Iterable[zio.aws.iam.model.Statement]] =
      Optional.Absent,
    missingContextValues: Optional[Iterable[ContextKeyNameType]] =
      Optional.Absent,
    evalDecisionDetails: Optional[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = Optional.Absent,
    permissionsBoundaryDecisionDetail: Optional[
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ResourceSpecificResult = {
    import ResourceSpecificResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ResourceSpecificResult
      .builder()
      .evalResourceName(
        ResourceNameType.unwrap(evalResourceName): java.lang.String
      )
      .evalResourceDecision(evalResourceDecision.unwrap)
      .optionallyWith(
        matchedStatements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchedStatements)
      .optionallyWith(
        missingContextValues.map(value =>
          value.map { item =>
            ContextKeyNameType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.missingContextValues)
      .optionallyWith(
        evalDecisionDetails.map(value =>
          value
            .map({ case (key, value) =>
              (EvalDecisionSourceType
                .unwrap(key): java.lang.String) -> value.unwrap.toString
            })
            .asJava
        )
      )(_.evalDecisionDetailsWithStrings)
      .optionallyWith(
        permissionsBoundaryDecisionDetail.map(value => value.buildAwsValue())
      )(_.permissionsBoundaryDecisionDetail)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ResourceSpecificResult.ReadOnly =
    zio.aws.iam.model.ResourceSpecificResult.wrap(buildAwsValue())
}
object ResourceSpecificResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ResourceSpecificResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ResourceSpecificResult =
      zio.aws.iam.model.ResourceSpecificResult(
        evalResourceName,
        evalResourceDecision,
        matchedStatements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        missingContextValues.map(value => value),
        evalDecisionDetails.map(value => value),
        permissionsBoundaryDecisionDetail.map(value => value.asEditable)
      )
    def evalResourceName: ResourceNameType
    def evalResourceDecision: zio.aws.iam.model.PolicyEvaluationDecisionType
    def matchedStatements: Optional[List[zio.aws.iam.model.Statement.ReadOnly]]
    def missingContextValues: Optional[List[ContextKeyNameType]]
    def evalDecisionDetails: Optional[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]]
    def permissionsBoundaryDecisionDetail
        : Optional[zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly]
    def getEvalResourceName: ZIO[Any, Nothing, ResourceNameType] =
      ZIO.succeed(evalResourceName)
    def getEvalResourceDecision
        : ZIO[Any, Nothing, zio.aws.iam.model.PolicyEvaluationDecisionType] =
      ZIO.succeed(evalResourceDecision)
    def getMatchedStatements
        : ZIO[Any, AwsError, List[zio.aws.iam.model.Statement.ReadOnly]] =
      AwsError.unwrapOptionField("matchedStatements", matchedStatements)
    def getMissingContextValues: ZIO[Any, AwsError, List[ContextKeyNameType]] =
      AwsError.unwrapOptionField("missingContextValues", missingContextValues)
    def getEvalDecisionDetails: ZIO[Any, AwsError, Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = AwsError.unwrapOptionField("evalDecisionDetails", evalDecisionDetails)
    def getPermissionsBoundaryDecisionDetail: ZIO[
      Any,
      AwsError,
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly
    ] = AwsError.unwrapOptionField(
      "permissionsBoundaryDecisionDetail",
      permissionsBoundaryDecisionDetail
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ResourceSpecificResult
  ) extends zio.aws.iam.model.ResourceSpecificResult.ReadOnly {
    override val evalResourceName: ResourceNameType =
      zio.aws.iam.model.primitives.ResourceNameType(impl.evalResourceName())
    override val evalResourceDecision
        : zio.aws.iam.model.PolicyEvaluationDecisionType =
      zio.aws.iam.model.PolicyEvaluationDecisionType
        .wrap(impl.evalResourceDecision())
    override val matchedStatements
        : Optional[List[zio.aws.iam.model.Statement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchedStatements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.Statement.wrap(item)
          }.toList
        )
    override val missingContextValues: Optional[List[ContextKeyNameType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.missingContextValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iam.model.primitives.ContextKeyNameType(item)
          }.toList
        )
    override val evalDecisionDetails: Optional[Map[
      EvalDecisionSourceType,
      zio.aws.iam.model.PolicyEvaluationDecisionType
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.evalDecisionDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iam.model.primitives.EvalDecisionSourceType(
              key
            ) -> zio.aws.iam.model.PolicyEvaluationDecisionType.wrap(value)
          })
          .toMap
      )
    override val permissionsBoundaryDecisionDetail: Optional[
      zio.aws.iam.model.PermissionsBoundaryDecisionDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionsBoundaryDecisionDetail())
      .map(value =>
        zio.aws.iam.model.PermissionsBoundaryDecisionDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ResourceSpecificResult
  ): zio.aws.iam.model.ResourceSpecificResult.ReadOnly = new Wrapper(impl)
}
