package zio.aws.iam.model
import zio.aws.iam.model.primitives.{ArnType, RegionNameType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RoleUsageType(
    region: Optional[RegionNameType] = Optional.Absent,
    resources: Optional[Iterable[ArnType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.RoleUsageType = {
    import RoleUsageType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.RoleUsageType
      .builder()
      .optionallyWith(
        region.map(value => RegionNameType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            ArnType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.RoleUsageType.ReadOnly =
    zio.aws.iam.model.RoleUsageType.wrap(buildAwsValue())
}
object RoleUsageType {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iam.model.RoleUsageType] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.RoleUsageType = zio.aws.iam.model
      .RoleUsageType(region.map(value => value), resources.map(value => value))
    def region: Optional[RegionNameType]
    def resources: Optional[List[ArnType]]
    def getRegion: ZIO[Any, AwsError, RegionNameType] =
      AwsError.unwrapOptionField("region", region)
    def getResources: ZIO[Any, AwsError, List[ArnType]] =
      AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.RoleUsageType
  ) extends zio.aws.iam.model.RoleUsageType.ReadOnly {
    override val region: Optional[RegionNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.iam.model.primitives.RegionNameType(value))
    override val resources: Optional[List[ArnType]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iam.model.primitives.ArnType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.RoleUsageType
  ): zio.aws.iam.model.RoleUsageType.ReadOnly = new Wrapper(impl)
}
