package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  ArnType,
  IdType,
  DateType,
  PathType,
  ServerCertificateNameType
}
import scala.jdk.CollectionConverters.*
final case class ServerCertificateMetadata(
    path: PathType,
    serverCertificateName: ServerCertificateNameType,
    serverCertificateId: IdType,
    arn: ArnType,
    uploadDate: Optional[DateType] = Optional.Absent,
    expiration: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.ServerCertificateMetadata = {
    import ServerCertificateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.ServerCertificateMetadata
      .builder()
      .path(PathType.unwrap(path): java.lang.String)
      .serverCertificateName(
        ServerCertificateNameType.unwrap(
          serverCertificateName
        ): java.lang.String
      )
      .serverCertificateId(IdType.unwrap(serverCertificateId): java.lang.String)
      .arn(ArnType.unwrap(arn): java.lang.String)
      .optionallyWith(uploadDate.map(value => DateType.unwrap(value): Instant))(
        _.uploadDate
      )
      .optionallyWith(expiration.map(value => DateType.unwrap(value): Instant))(
        _.expiration
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.ServerCertificateMetadata.ReadOnly =
    zio.aws.iam.model.ServerCertificateMetadata.wrap(buildAwsValue())
}
object ServerCertificateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.ServerCertificateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.ServerCertificateMetadata =
      zio.aws.iam.model.ServerCertificateMetadata(
        path,
        serverCertificateName,
        serverCertificateId,
        arn,
        uploadDate.map(value => value),
        expiration.map(value => value)
      )
    def path: PathType
    def serverCertificateName: ServerCertificateNameType
    def serverCertificateId: IdType
    def arn: ArnType
    def uploadDate: Optional[DateType]
    def expiration: Optional[DateType]
    def getPath: ZIO[Any, Nothing, PathType] = ZIO.succeed(path)
    def getServerCertificateName: ZIO[Any, Nothing, ServerCertificateNameType] =
      ZIO.succeed(serverCertificateName)
    def getServerCertificateId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(serverCertificateId)
    def getArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(arn)
    def getUploadDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("uploadDate", uploadDate)
    def getExpiration: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.ServerCertificateMetadata
  ) extends zio.aws.iam.model.ServerCertificateMetadata.ReadOnly {
    override val path: PathType =
      zio.aws.iam.model.primitives.PathType(impl.path())
    override val serverCertificateName: ServerCertificateNameType =
      zio.aws.iam.model.primitives
        .ServerCertificateNameType(impl.serverCertificateName())
    override val serverCertificateId: IdType =
      zio.aws.iam.model.primitives.IdType(impl.serverCertificateId())
    override val arn: ArnType = zio.aws.iam.model.primitives.ArnType(impl.arn())
    override val uploadDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadDate())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val expiration: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.ServerCertificateMetadata
  ): zio.aws.iam.model.ServerCertificateMetadata.ReadOnly = new Wrapper(impl)
}
