package zio.aws.iam.model
import zio.aws.iam.model.primitives.{PolicyVersionIdType, ArnType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetDefaultPolicyVersionRequest(
    policyArn: ArnType,
    versionId: PolicyVersionIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest = {
    import SetDefaultPolicyVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest
      .builder()
      .policyArn(ArnType.unwrap(policyArn): java.lang.String)
      .versionId(PolicyVersionIdType.unwrap(versionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.SetDefaultPolicyVersionRequest.ReadOnly =
    zio.aws.iam.model.SetDefaultPolicyVersionRequest.wrap(buildAwsValue())
}
object SetDefaultPolicyVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.SetDefaultPolicyVersionRequest =
      zio.aws.iam.model.SetDefaultPolicyVersionRequest(policyArn, versionId)
    def policyArn: ArnType
    def versionId: PolicyVersionIdType
    def getPolicyArn: ZIO[Any, Nothing, ArnType] = ZIO.succeed(policyArn)
    def getVersionId: ZIO[Any, Nothing, PolicyVersionIdType] =
      ZIO.succeed(versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest
  ) extends zio.aws.iam.model.SetDefaultPolicyVersionRequest.ReadOnly {
    override val policyArn: ArnType =
      zio.aws.iam.model.primitives.ArnType(impl.policyArn())
    override val versionId: PolicyVersionIdType =
      zio.aws.iam.model.primitives.PolicyVersionIdType(impl.versionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest
  ): zio.aws.iam.model.SetDefaultPolicyVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
