package zio.aws.iam.model
import scala.jdk.CollectionConverters.*
sealed trait StatusType {
  def unwrap: software.amazon.awssdk.services.iam.model.StatusType
}
object StatusType {
  def wrap(
      value: software.amazon.awssdk.services.iam.model.StatusType
  ): zio.aws.iam.model.StatusType = value match {
    case software.amazon.awssdk.services.iam.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iam.model.StatusType.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.iam.model.StatusType.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion extends zio.aws.iam.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.iam.model.StatusType =
      software.amazon.awssdk.services.iam.model.StatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.iam.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.iam.model.StatusType =
      software.amazon.awssdk.services.iam.model.StatusType.ACTIVE
  }
  case object Inactive extends zio.aws.iam.model.StatusType {
    override def unwrap: software.amazon.awssdk.services.iam.model.StatusType =
      software.amazon.awssdk.services.iam.model.StatusType.INACTIVE
  }
}
