package zio.aws.iam.model
import zio.aws.iam.model.primitives.InstanceProfileNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest = {
    import TagInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.TagInstanceProfileRequest.wrap(buildAwsValue())
}
object TagInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagInstanceProfileRequest =
      zio.aws.iam.model.TagInstanceProfileRequest(
        instanceProfileName,
        tags.map { item =>
          item.asEditable
        }
      )
    def instanceProfileName: InstanceProfileNameType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest
  ) extends zio.aws.iam.model.TagInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagInstanceProfileRequest
  ): zio.aws.iam.model.TagInstanceProfileRequest.ReadOnly = new Wrapper(impl)
}
