package zio.aws.iam.model
import zio.aws.iam.model.primitives.RoleNameType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagRoleRequest(
    roleName: RoleNameType,
    tags: Iterable[zio.aws.iam.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TagRoleRequest = {
    import TagRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TagRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TagRoleRequest.ReadOnly =
    zio.aws.iam.model.TagRoleRequest.wrap(buildAwsValue())
}
object TagRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TagRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TagRoleRequest =
      zio.aws.iam.model.TagRoleRequest(
        roleName,
        tags.map { item =>
          item.asEditable
        }
      )
    def roleName: RoleNameType
    def tags: List[zio.aws.iam.model.Tag.ReadOnly]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iam.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TagRoleRequest
  ) extends zio.aws.iam.model.TagRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val tags: List[zio.aws.iam.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iam.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TagRoleRequest
  ): zio.aws.iam.model.TagRoleRequest.ReadOnly = new Wrapper(impl)
}
