package zio.aws.iam.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{DateType, ArnType, StringType}
import scala.jdk.CollectionConverters.*
final case class TrackedActionLastAccessed(
    actionName: Optional[StringType] = Optional.Absent,
    lastAccessedEntity: Optional[ArnType] = Optional.Absent,
    lastAccessedTime: Optional[DateType] = Optional.Absent,
    lastAccessedRegion: Optional[StringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed = {
    import TrackedActionLastAccessed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
      .builder()
      .optionallyWith(actionName.map(value => value: java.lang.String))(
        _.actionName
      )
      .optionallyWith(
        lastAccessedEntity.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.lastAccessedEntity)
      .optionallyWith(
        lastAccessedTime.map(value => DateType.unwrap(value): Instant)
      )(_.lastAccessedTime)
      .optionallyWith(lastAccessedRegion.map(value => value: java.lang.String))(
        _.lastAccessedRegion
      )
      .build()
  }
  def asReadOnly: zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly =
    zio.aws.iam.model.TrackedActionLastAccessed.wrap(buildAwsValue())
}
object TrackedActionLastAccessed {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.TrackedActionLastAccessed =
      zio.aws.iam.model.TrackedActionLastAccessed(
        actionName.map(value => value),
        lastAccessedEntity.map(value => value),
        lastAccessedTime.map(value => value),
        lastAccessedRegion.map(value => value)
      )
    def actionName: Optional[StringType]
    def lastAccessedEntity: Optional[ArnType]
    def lastAccessedTime: Optional[DateType]
    def lastAccessedRegion: Optional[StringType]
    def getActionName: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getLastAccessedEntity: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("lastAccessedEntity", lastAccessedEntity)
    def getLastAccessedTime: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastAccessedTime", lastAccessedTime)
    def getLastAccessedRegion: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("lastAccessedRegion", lastAccessedRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ) extends zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly {
    override val actionName: Optional[StringType] = zio.aws.core.internal
      .optionalFromNullable(impl.actionName())
      .map(value => value: StringType)
    override val lastAccessedEntity: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAccessedEntity())
      .map(value => zio.aws.iam.model.primitives.ArnType(value))
    override val lastAccessedTime: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAccessedTime())
      .map(value => zio.aws.iam.model.primitives.DateType(value))
    override val lastAccessedRegion: Optional[StringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAccessedRegion())
        .map(value => value: StringType)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.TrackedActionLastAccessed
  ): zio.aws.iam.model.TrackedActionLastAccessed.ReadOnly = new Wrapper(impl)
}
