package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, InstanceProfileNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagInstanceProfileRequest(
    instanceProfileName: InstanceProfileNameType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest = {
    import UntagInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest
      .builder()
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagInstanceProfileRequest.ReadOnly =
    zio.aws.iam.model.UntagInstanceProfileRequest.wrap(buildAwsValue())
}
object UntagInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagInstanceProfileRequest =
      zio.aws.iam.model
        .UntagInstanceProfileRequest(instanceProfileName, tagKeys)
    def instanceProfileName: InstanceProfileNameType
    def tagKeys: List[TagKeyType]
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest
  ) extends zio.aws.iam.model.UntagInstanceProfileRequest.ReadOnly {
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.iam.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagInstanceProfileRequest
  ): zio.aws.iam.model.UntagInstanceProfileRequest.ReadOnly = new Wrapper(impl)
}
