package zio.aws.iam.model
import zio.aws.iam.model.primitives.{TagKeyType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagRoleRequest(
    roleName: RoleNameType,
    tagKeys: Iterable[TagKeyType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UntagRoleRequest = {
    import UntagRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UntagRoleRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UntagRoleRequest.ReadOnly =
    zio.aws.iam.model.UntagRoleRequest.wrap(buildAwsValue())
}
object UntagRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UntagRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UntagRoleRequest =
      zio.aws.iam.model.UntagRoleRequest(roleName, tagKeys)
    def roleName: RoleNameType
    def tagKeys: List[TagKeyType]
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyType]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UntagRoleRequest
  ) extends zio.aws.iam.model.UntagRoleRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val tagKeys: List[TagKeyType] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iam.model.primitives.TagKeyType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UntagRoleRequest
  ): zio.aws.iam.model.UntagRoleRequest.ReadOnly = new Wrapper(impl)
}
