package zio.aws.iam.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iam.model.primitives.{
  BooleanType,
  BooleanObjectType,
  MinimumPasswordLengthType,
  MaxPasswordAgeType,
  PasswordReusePreventionType
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateAccountPasswordPolicyRequest(
    minimumPasswordLength: Optional[MinimumPasswordLengthType] =
      Optional.Absent,
    requireSymbols: Optional[BooleanType] = Optional.Absent,
    requireNumbers: Optional[BooleanType] = Optional.Absent,
    requireUppercaseCharacters: Optional[BooleanType] = Optional.Absent,
    requireLowercaseCharacters: Optional[BooleanType] = Optional.Absent,
    allowUsersToChangePassword: Optional[BooleanType] = Optional.Absent,
    maxPasswordAge: Optional[MaxPasswordAgeType] = Optional.Absent,
    passwordReusePrevention: Optional[PasswordReusePreventionType] =
      Optional.Absent,
    hardExpiry: Optional[BooleanObjectType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest = {
    import UpdateAccountPasswordPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest
      .builder()
      .optionallyWith(
        minimumPasswordLength.map(value =>
          MinimumPasswordLengthType.unwrap(value): Integer
        )
      )(_.minimumPasswordLength)
      .optionallyWith(
        requireSymbols.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireSymbols)
      .optionallyWith(
        requireNumbers.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireNumbers)
      .optionallyWith(
        requireUppercaseCharacters.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireUppercaseCharacters)
      .optionallyWith(
        requireLowercaseCharacters.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.requireLowercaseCharacters)
      .optionallyWith(
        allowUsersToChangePassword.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.allowUsersToChangePassword)
      .optionallyWith(
        maxPasswordAge.map(value => MaxPasswordAgeType.unwrap(value): Integer)
      )(_.maxPasswordAge)
      .optionallyWith(
        passwordReusePrevention.map(value =>
          PasswordReusePreventionType.unwrap(value): Integer
        )
      )(_.passwordReusePrevention)
      .optionallyWith(
        hardExpiry.map(value =>
          BooleanObjectType.unwrap(value): java.lang.Boolean
        )
      )(_.hardExpiry)
      .build()
  }
  def asReadOnly
      : zio.aws.iam.model.UpdateAccountPasswordPolicyRequest.ReadOnly =
    zio.aws.iam.model.UpdateAccountPasswordPolicyRequest.wrap(buildAwsValue())
}
object UpdateAccountPasswordPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateAccountPasswordPolicyRequest =
      zio.aws.iam.model.UpdateAccountPasswordPolicyRequest(
        minimumPasswordLength.map(value => value),
        requireSymbols.map(value => value),
        requireNumbers.map(value => value),
        requireUppercaseCharacters.map(value => value),
        requireLowercaseCharacters.map(value => value),
        allowUsersToChangePassword.map(value => value),
        maxPasswordAge.map(value => value),
        passwordReusePrevention.map(value => value),
        hardExpiry.map(value => value)
      )
    def minimumPasswordLength: Optional[MinimumPasswordLengthType]
    def requireSymbols: Optional[BooleanType]
    def requireNumbers: Optional[BooleanType]
    def requireUppercaseCharacters: Optional[BooleanType]
    def requireLowercaseCharacters: Optional[BooleanType]
    def allowUsersToChangePassword: Optional[BooleanType]
    def maxPasswordAge: Optional[MaxPasswordAgeType]
    def passwordReusePrevention: Optional[PasswordReusePreventionType]
    def hardExpiry: Optional[BooleanObjectType]
    def getMinimumPasswordLength
        : ZIO[Any, AwsError, MinimumPasswordLengthType] =
      AwsError.unwrapOptionField("minimumPasswordLength", minimumPasswordLength)
    def getRequireSymbols: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireSymbols", requireSymbols)
    def getRequireNumbers: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("requireNumbers", requireNumbers)
    def getRequireUppercaseCharacters: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "requireUppercaseCharacters",
        requireUppercaseCharacters
      )
    def getRequireLowercaseCharacters: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "requireLowercaseCharacters",
        requireLowercaseCharacters
      )
    def getAllowUsersToChangePassword: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "allowUsersToChangePassword",
        allowUsersToChangePassword
      )
    def getMaxPasswordAge: ZIO[Any, AwsError, MaxPasswordAgeType] =
      AwsError.unwrapOptionField("maxPasswordAge", maxPasswordAge)
    def getPasswordReusePrevention
        : ZIO[Any, AwsError, PasswordReusePreventionType] = AwsError
      .unwrapOptionField("passwordReusePrevention", passwordReusePrevention)
    def getHardExpiry: ZIO[Any, AwsError, BooleanObjectType] =
      AwsError.unwrapOptionField("hardExpiry", hardExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest
  ) extends zio.aws.iam.model.UpdateAccountPasswordPolicyRequest.ReadOnly {
    override val minimumPasswordLength: Optional[MinimumPasswordLengthType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumPasswordLength())
        .map(value =>
          zio.aws.iam.model.primitives.MinimumPasswordLengthType(value)
        )
    override val requireSymbols: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireSymbols())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireNumbers: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.requireNumbers())
      .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireUppercaseCharacters: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireUppercaseCharacters())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val requireLowercaseCharacters: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireLowercaseCharacters())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val allowUsersToChangePassword: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowUsersToChangePassword())
        .map(value => zio.aws.iam.model.primitives.BooleanType(value))
    override val maxPasswordAge: Optional[MaxPasswordAgeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPasswordAge())
        .map(value => zio.aws.iam.model.primitives.MaxPasswordAgeType(value))
    override val passwordReusePrevention
        : Optional[PasswordReusePreventionType] = zio.aws.core.internal
      .optionalFromNullable(impl.passwordReusePrevention())
      .map(value =>
        zio.aws.iam.model.primitives.PasswordReusePreventionType(value)
      )
    override val hardExpiry: Optional[BooleanObjectType] = zio.aws.core.internal
      .optionalFromNullable(impl.hardExpiry())
      .map(value => zio.aws.iam.model.primitives.BooleanObjectType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest
  ): zio.aws.iam.model.UpdateAccountPasswordPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
