package zio.aws.iam.model
import zio.aws.iam.model.primitives.{RoleDescriptionType, RoleNameType}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRoleDescriptionRequest(
    roleName: RoleNameType,
    description: RoleDescriptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest = {
    import UpdateRoleDescriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest
      .builder()
      .roleName(RoleNameType.unwrap(roleName): java.lang.String)
      .description(RoleDescriptionType.unwrap(description): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateRoleDescriptionRequest.ReadOnly =
    zio.aws.iam.model.UpdateRoleDescriptionRequest.wrap(buildAwsValue())
}
object UpdateRoleDescriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateRoleDescriptionRequest =
      zio.aws.iam.model.UpdateRoleDescriptionRequest(roleName, description)
    def roleName: RoleNameType
    def description: RoleDescriptionType
    def getRoleName: ZIO[Any, Nothing, RoleNameType] = ZIO.succeed(roleName)
    def getDescription: ZIO[Any, Nothing, RoleDescriptionType] =
      ZIO.succeed(description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest
  ) extends zio.aws.iam.model.UpdateRoleDescriptionRequest.ReadOnly {
    override val roleName: RoleNameType =
      zio.aws.iam.model.primitives.RoleNameType(impl.roleName())
    override val description: RoleDescriptionType =
      zio.aws.iam.model.primitives.RoleDescriptionType(impl.description())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest
  ): zio.aws.iam.model.UpdateRoleDescriptionRequest.ReadOnly = new Wrapper(impl)
}
