package zio.aws.iam.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRoleDescriptionResponse(
    role: Optional[zio.aws.iam.model.Role] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse = {
    import UpdateRoleDescriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse
      .builder()
      .optionallyWith(role.map(value => value.buildAwsValue()))(_.role)
      .build()
  }
  def asReadOnly: zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly =
    zio.aws.iam.model.UpdateRoleDescriptionResponse.wrap(buildAwsValue())
}
object UpdateRoleDescriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iam.model.UpdateRoleDescriptionResponse =
      zio.aws.iam.model
        .UpdateRoleDescriptionResponse(role.map(value => value.asEditable))
    def role: Optional[zio.aws.iam.model.Role.ReadOnly]
    def getRole: ZIO[Any, AwsError, zio.aws.iam.model.Role.ReadOnly] =
      AwsError.unwrapOptionField("role", role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse
  ) extends zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly {
    override val role: Optional[zio.aws.iam.model.Role.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.iam.model.Role.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse
  ): zio.aws.iam.model.UpdateRoleDescriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
